
#include <cstdio>
#include <iostream>
#include <vector>
#include <algorithm>
#include <cstring>
#include <string>
#include <cmath>
#include <map>
#include <set>
#include <climits>
#include <cassert>
#include <cctype>
using namespace std;

typedef long long ll;
typedef double dbl;
typedef long double ld;

#define mp make_pair
#define pb push_back
#define sz(x) (int)x.size()
#define all(x) x.begin(),x.end()
#define X first
#define Y second

const int maxn = 1000 * 100 + 1;
const dbl eps = (dbl)1e-6;
const ll mod = (ll)1e9 + 7;

ll dp[2010][2010], sum[2010][2010], c[2010];

ll get(ll q) {
	if (q >= mod)
		q -= mod;
	return q;
}

ll f(int u, int d, int c) {
	return get(get(get(sum[d][c] - sum[u][c]) + mod) + dp[u][c]);
}

ll ppow(ll a, ll b) {
	if (b == 0) return 1LL;
	if (b % 2 == 0) {
		ll t = ppow(a, b / 2) % mod;
		return (t * t) % mod;
	} else {
		return (ppow(a, b - 1) * a) % mod;
	}
}

int main() {
	freopen("input.txt", "r", stdin);
	freopen("output.txt", "w", stdout);
	
	while (true) {
		int n, x;
		ll d;
		scanf("%d%lld%d", &n, &d, &x);

		if (n == 0 && x == 0 && d == 0)
			break;

		// border case
		if (x == 1) {
			printf("0\n");
			continue;
		}
	
		// init
		for (int i = 1; i <= x - 1; i++) {
			dp[i][1] = 1;
			sum[i][1] = i;
		}
		for (int i = x; i <= n; i++) {
			dp[i][1] = 0;
			sum[i][1] = x - 1;
		}
		for (int i = 2; i <= n; i++) {
			dp[1][i] = 0;
			sum[1][i] = 0;
		}
		
		// count dp
		for (int s = 2; s <= n; s++) {
			for (int t = 2; t <= s; t++) {
				dp[s][t] = f(max(s - x + 1, 1), s - 1, t - 1);
				sum[s][t] = get(sum[s - 1][t] + dp[s][t]);
			}
		}

		// count C
		ll p1 = 1LL, p2 = 1LL;
		c[0] = 1LL;
		for (ll i = 1LL; i <= min((ll)n, d); i++) {
			p1 = (p1 * (ll)(d - i + 1)) % mod;
			p2 = (p2 * i) % mod;
			c[i] = (ppow(p2, mod - 2) * p1) % mod;
		}

		// count ans
		ll ans = 0LL;
		for (int i = 1; i <= min((ll)n, d); i++)
			ans = get(ans + ((dp[n][i] * c[i]) % mod));
		printf("%lld\n", ans);
	}
	return 0;
}